// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 11, Aufgabe 2
// "Zahlenmengen beliebiger Groesse"

// Sets of integers
class Set {
	int[] set;
	int max;
	
	Set(int maxElem) {
		max = maxElem;
		set = new int[1 + max / 32];
	}
	
	void include(int x) {
		if (x >= 0 && x <= max) set[x / 32] |= 1 << (x % 32);
	}
	
	void exclude(int x) {
		if (x >= 0 && x <= max) set[x / 32] &= ~(1 << (x % 32));
	}
	
	boolean contains(int x) {
		return x >= 0 && x <= max && ((1 << (x % 32)) & set[x / 32]) != 0;
	}
	
	void union(Set s) {
		if (max == s.max)
			for (int i = 0; i < set.length; i++) set[i] |= s.set[i];
	}
	
	void intersect(Set s) {
		if (max == s.max)
			for (int i = 0; i < set.length; i++) set[i] &= s.set[i];
	}
	
	public String toString() {
		StringBuffer b = new StringBuffer();
		boolean first = true;
		b.append("{");
		for (int i = 0; i <= max; i++)
			if (contains(i)) {
				if (first) first = false; else b.append(",");
				b.append(i);
			}
		b.append("}");
		return b.toString();
	}
}

public class A2 {
	
	public static void main(String args[]) {
		Set s = new Set(127);
		s.include(33);
		s.include(5);
		Out.println("s = " + s);
		
		Set s1 = new Set(127);
		s1.include(5);
		s1.include(6);
		s1.include(100);
		s.union(s1);
		Out.println("s = " + s);
		
		s1 = new Set(127);
		s1.include(33);
		s1.include(100);
		s.intersect(s1);
		Out.println("s = " + s);
		
		s.exclude(100);
		Out.println("s = " + s);
	}
}
